/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driverinstaller;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.filechooser.FileSystemView;

public class Installer {
    private static final String logFileName = "ECGDriverInstaller.log";
    private static final String certificateFile = "smartecg-certificate.crt";
    private static final String driverDirName = "SmartECG";
    private static final String driverFile = "smartecg.jar";
    private static final String driverFileOld = "smartecg-old.jar";
    private static final String driverFileNew = "smartecg-new.jar";
    private static final String installerFile = "ecg-driver-installer.jar";
    private static final String launchDriverScriptFileName = "run.bat";
    private static final String launchDriverDebugScriptFileName = "rundbg.bat";
    private static final String bundledJreDir = "jre";
    private static final String driverWebInterfaceUrl = "https://localhost:20000";
    private static String driverDir;
    private static String installerDir;
    private static final long driverStartTimeout = 5000L;
    private static Logger logger;

    private static void initializeLogger() throws Exception {
        FileHandler fileHandler = new FileHandler(Paths.get(FileSystemView.getFileSystemView().getDefaultDirectory().getPath(), logFileName).toString());
        fileHandler.setFormatter(new SimpleFormatter());
        fileHandler.setEncoding("UTF-8");
        logger = Logger.getLogger(Installer.class.getName());
        logger.addHandler(fileHandler);
    }

    private static void launchProcess(String[] command, String workingDir, boolean wait) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(command);
        if (workingDir != null) {
            builder.directory(new File(workingDir));
        }
        builder.redirectErrorStream(true);
        Process process = builder.start();
        long startTime = System.currentTimeMillis();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while (wait ? process.isAlive() : System.currentTimeMillis() < startTime + 5000L) {
            if (!bufferedReader.ready()) continue;
            logger.info(bufferedReader.readLine());
        }
    }

    private static void installCertificate() throws Exception {
        String[] certificateInstallCommand = new String[]{"certutil", "-user", "-addstore", "Root", certificateFile};
        Installer.launchProcess(certificateInstallCommand, installerDir, true);
    }

    private static void installDriver() throws Exception {
        Files.createDirectories(Paths.get(driverDir, new String[0]), new FileAttribute[0]);
        Files.copy(Paths.get(installerDir, driverFile), Paths.get(driverDir, driverFile), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(Paths.get(installerDir, installerFile), Paths.get(driverDir, installerFile), StandardCopyOption.REPLACE_EXISTING);
        String disk = driverDir.substring(0, 2) + System.lineSeparator();
        String changeDir = "cd %~dp0" + System.lineSeparator();
        String launchDriver = "start jre\\bin\\javaw.exe -jar smartecg.jar";
        String launchDriverDebug = "start jre\\bin\\javaw.exe -Dlogging.threshold=TRACE -jar smartecg.jar";
        Files.write(Paths.get(driverDir, launchDriverScriptFileName), disk.getBytes(), new OpenOption[0]);
        Files.write(Paths.get(driverDir, launchDriverScriptFileName), changeDir.getBytes(), StandardOpenOption.APPEND);
        Files.write(Paths.get(driverDir, launchDriverScriptFileName), launchDriver.getBytes(), StandardOpenOption.APPEND);
        Files.write(Paths.get(driverDir, launchDriverDebugScriptFileName), disk.getBytes(), new OpenOption[0]);
        Files.write(Paths.get(driverDir, launchDriverDebugScriptFileName), changeDir.getBytes(), StandardOpenOption.APPEND);
        Files.write(Paths.get(driverDir, launchDriverDebugScriptFileName), launchDriverDebug.getBytes(), StandardOpenOption.APPEND);
        final Path bundledJreTargetPath = Paths.get(driverDir, bundledJreDir);
        final Path bundledJreSourcePath = Paths.get(installerDir, bundledJreDir);
        Files.walkFileTree(bundledJreSourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(bundledJreTargetPath.resolve(bundledJreSourcePath.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, bundledJreTargetPath.resolve(bundledJreSourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void addDriverToAutostart() throws Exception {
        String launchDriverCommand = Paths.get(driverDir, launchDriverScriptFileName).toString();
        String[] addDriverToAutostartCommand = new String[]{"reg", "add", "HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run", "/v", driverDirName, "/t", "REG_SZ", "/d", launchDriverCommand, "/f"};
        Installer.launchProcess(addDriverToAutostartCommand, null, true);
    }

    private static void launchDriver() throws Exception {
        String[] launchDriverCommand = new String[]{Paths.get(driverDir, launchDriverScriptFileName).toString()};
        Installer.launchProcess(launchDriverCommand, null, false);
    }

    private static void updateDriver() throws Exception {
        Files.move(Paths.get(driverDir, driverFile), Paths.get(driverDir, driverFileOld), StandardCopyOption.REPLACE_EXISTING);
        Files.move(Paths.get(driverDir, driverFileNew), Paths.get(driverDir, driverFile), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void openDriverWebInterface() throws Exception {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(driverWebInterfaceUrl));
        }
    }

    public static void main(String[] args) {
        try {
            Installer.initializeLogger();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            installerDir = Paths.get("", new String[0]).toAbsolutePath().toString();
            driverDir = Paths.get(FileSystemView.getFileSystemView().getDefaultDirectory().getPath(), driverDirName).toString();
            logger.info("Current directory: " + installerDir);
            logger.info("Driver installation directory: " + driverDir);
            if (args.length == 0) {
                logger.info("Installing certificate");
                Installer.installCertificate();
                logger.info("Installing driver");
                Installer.installDriver();
                logger.info("Adding driver to autostart");
                Installer.addDriverToAutostart();
                logger.info("Launching driver");
                Installer.launchDriver();
                logger.info("Opening driver web interface");
                Installer.openDriverWebInterface();
            } else if ("-update".equals(args[0])) {
                Thread.sleep(1000L);
                logger.info("Updating driver");
                Installer.updateDriver();
                logger.info("Launching driver");
                Installer.launchDriver();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
        }
    }
}

