/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import cmc.ecg.driver.dto.SourceType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApplicationConfig {
    @Value(value="${ecg.source.default}")
    private SourceType defaultSource;
    @Value(value="${ecg.signals.defaultSignal}")
    private String defaultSignal;
    @Value(value="${ecg.signals.outputDirectory}")
    private String signalsOutputDirectory;
    @Value(value="${ecg.signals.inputDirectory}")
    private String signalsInputDirectory;

    public String getInputSignal(String file) {
        return this.signalsInputDirectory + "/" + file;
    }

    public String getOutputSignal(String file) {
        return this.signalsOutputDirectory + "/" + file;
    }

    public SourceType getDefaultSource() {
        return this.defaultSource;
    }

    public String getDefaultSignal() {
        return this.defaultSignal;
    }

    public String getSignalsOutputDirectory() {
        return this.signalsOutputDirectory;
    }

    public String getSignalsInputDirectory() {
        return this.signalsInputDirectory;
    }

    public void setDefaultSource(SourceType defaultSource) {
        this.defaultSource = defaultSource;
    }

    public void setDefaultSignal(String defaultSignal) {
        this.defaultSignal = defaultSignal;
    }

    public void setSignalsOutputDirectory(String signalsOutputDirectory) {
        this.signalsOutputDirectory = signalsOutputDirectory;
    }

    public void setSignalsInputDirectory(String signalsInputDirectory) {
        this.signalsInputDirectory = signalsInputDirectory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationConfig)) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SourceType this$defaultSource = this.getDefaultSource();
        SourceType other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        String this$defaultSignal = this.getDefaultSignal();
        String other$defaultSignal = other.getDefaultSignal();
        if (this$defaultSignal == null ? other$defaultSignal != null : !this$defaultSignal.equals(other$defaultSignal)) {
            return false;
        }
        String this$signalsOutputDirectory = this.getSignalsOutputDirectory();
        String other$signalsOutputDirectory = other.getSignalsOutputDirectory();
        if (this$signalsOutputDirectory == null ? other$signalsOutputDirectory != null : !this$signalsOutputDirectory.equals(other$signalsOutputDirectory)) {
            return false;
        }
        String this$signalsInputDirectory = this.getSignalsInputDirectory();
        String other$signalsInputDirectory = other.getSignalsInputDirectory();
        return !(this$signalsInputDirectory == null ? other$signalsInputDirectory != null : !this$signalsInputDirectory.equals(other$signalsInputDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceType $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        String $defaultSignal = this.getDefaultSignal();
        result = result * 59 + ($defaultSignal == null ? 43 : $defaultSignal.hashCode());
        String $signalsOutputDirectory = this.getSignalsOutputDirectory();
        result = result * 59 + ($signalsOutputDirectory == null ? 43 : $signalsOutputDirectory.hashCode());
        String $signalsInputDirectory = this.getSignalsInputDirectory();
        result = result * 59 + ($signalsInputDirectory == null ? 43 : $signalsInputDirectory.hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationConfig(defaultSource=" + this.getDefaultSource() + ", defaultSignal=" + this.getDefaultSignal() + ", signalsOutputDirectory=" + this.getSignalsOutputDirectory() + ", signalsInputDirectory=" + this.getSignalsInputDirectory() + ")";
    }
}

