/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import cmc.ecg.driver.ApplicationConfig;
import cmc.ecg.driver.dto.ConnectionDTO;
import cmc.ecg.driver.dto.SourceType;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    private static final String CONFIG_FILE = "config.json";
    @Autowired
    private ApplicationConfig applicationConfig;
    private String host;
    private String tcpPort;
    private String udpPort;
    private String key;
    private final List<ConnectionDTO> savedConnections = new LinkedList();

    @PostConstruct
    private void loadConfig() {
        block16: {
            try {
                Path configFilePath = Paths.get(CONFIG_FILE, new String[0]);
                if (Files.notExists(configFilePath, new LinkOption[0])) {
                    Files.createFile(configFilePath, new FileAttribute[0]);
                    break block16;
                }
                if (Files.size(configFilePath) == 0L) {
                    return;
                }
                JSONObject config = (JSONObject)new JSONParser().parse((Reader)new FileReader(CONFIG_FILE));
                this.host = (String)config.get((Object)"host");
                this.tcpPort = (String)config.get((Object)"tcpPort");
                this.udpPort = (String)config.get((Object)"udpPort");
                this.key = (String)config.get((Object)"key");
                boolean rewrite = false;
                JSONArray devices = (JSONArray)config.get((Object)"devices");
                if (devices != null) {
                    for (Object deviceObj : devices) {
                        Boolean last;
                        ConnectionDTO connectionDTO = new ConnectionDTO();
                        JSONObject device = (JSONObject)deviceObj;
                        String type = (String)device.get((Object)"type");
                        if (type != null) {
                            String port;
                            SourceType sourceType;
                            try {
                                sourceType = SourceType.valueOf((String)type);
                            }
                            catch (IllegalArgumentException e) {
                                if (type.equals("Bionet_Cardio_Care_2000")) {
                                    sourceType = SourceType.bionet;
                                    rewrite = true;
                                }
                                log.warn("Unexpected source type in config file: {}, skipping", (Object)type);
                                continue;
                            }
                            connectionDTO.setSourceType(sourceType);
                            if (Arrays.asList(SourceType.ek12t, SourceType.pe1201a, SourceType.btl, SourceType.axion, SourceType.fastecg, SourceType.fastecg_amp, SourceType.miniecg, SourceType.ucard).contains(sourceType) && (port = (String)device.get((Object)"port")) != null) {
                                connectionDTO.setPort(port);
                                connectionDTO.setPortSetByUser(Boolean.valueOf(!"auto".equals(port)));
                            }
                            if (sourceType == SourceType.btl) {
                                connectionDTO.setKey((String)device.get((Object)"key"));
                            }
                            if (sourceType == SourceType.bionet) {
                                connectionDTO.setHost((String)device.get((Object)"host"));
                                String tcpPort = (String)device.get((Object)"tcpPort");
                                String udpPort = (String)device.get((Object)"udpPort");
                                connectionDTO.setTcpPort(tcpPort == null ? 0 : Integer.parseInt(tcpPort));
                                connectionDTO.setUdpPort(udpPort == null ? 0 : Integer.parseInt(udpPort));
                                connectionDTO.setPortSetByUser(Boolean.valueOf(true));
                            }
                        }
                        if ((last = (Boolean)device.get((Object)"last")) != null && last.booleanValue()) {
                            connectionDTO.setLastActive(Boolean.valueOf(true));
                        }
                        this.savedConnections.add(connectionDTO);
                    }
                }
                if (rewrite) {
                    this.saveConfig();
                }
            }
            catch (IOException e) {
                log.error("Could not read or create configuration file", (Throwable)e);
            }
            catch (ParseException e) {
                log.error("Could not parse configuration file", (Throwable)e);
            }
        }
    }

    public List<ConnectionDTO> getSavedConnections() {
        return this.savedConnections;
    }

    public ConnectionDTO setLastInput(ConnectionDTO connectionDTO) {
        if (connectionDTO.getHost() == null) {
            connectionDTO.setHost(this.host);
        }
        if (connectionDTO.getTcpPort() == 0) {
            connectionDTO.setTcpPort(this.tcpPort == null ? 0 : Integer.parseInt(this.tcpPort));
        }
        if (connectionDTO.getUdpPort() == 0) {
            connectionDTO.setUdpPort(this.udpPort == null ? 0 : Integer.parseInt(this.udpPort));
        }
        if (connectionDTO.getKey() == null) {
            connectionDTO.setKey(this.key);
        }
        return connectionDTO;
    }

    public ConnectionDTO getLastActiveConnection() {
        for (ConnectionDTO connectionDTO : this.savedConnections) {
            if (!connectionDTO.getLastActive().booleanValue()) continue;
            return connectionDTO;
        }
        return new ConnectionDTO();
    }

    public void addConnection(ConnectionDTO connectionDTO) {
        if (!Arrays.asList(SourceType.ek12t, SourceType.bionet, SourceType.pe1201a, SourceType.btl, SourceType.axion, SourceType.fastecg, SourceType.fastecg_amp, SourceType.miniecg, SourceType.sapa, SourceType.ucard).contains(connectionDTO.getSourceType())) {
            return;
        }
        if (connectionDTO.getHost() != null) {
            this.host = connectionDTO.getHost();
        }
        if (connectionDTO.getTcpPort() != 0) {
            this.tcpPort = String.valueOf(connectionDTO.getTcpPort());
        }
        if (connectionDTO.getUdpPort() != 0) {
            this.udpPort = String.valueOf(connectionDTO.getUdpPort());
        }
        if (connectionDTO.getKey() != null) {
            this.key = connectionDTO.getKey();
        }
        this.savedConnections.forEach(savedConnection -> savedConnection.setLastActive(Boolean.valueOf(false)));
        for (ConnectionDTO savedConnection2 : this.savedConnections) {
            if (!connectionDTO.isEqual(savedConnection2)) continue;
            savedConnection2.setLastActive(Boolean.valueOf(true));
            this.saveConfig();
            return;
        }
        connectionDTO.setLastActive(Boolean.valueOf(true));
        this.savedConnections.add(connectionDTO);
        this.saveConfig();
    }

    public void saveConfig() {
        JSONObject config = new JSONObject();
        if (this.host != null) {
            config.put((Object)"host", (Object)this.host);
        }
        if (this.tcpPort != null) {
            config.put((Object)"tcpPort", (Object)this.tcpPort);
        }
        if (this.udpPort != null) {
            config.put((Object)"udpPort", (Object)this.udpPort);
        }
        if (this.key != null) {
            config.put((Object)"key", (Object)this.key);
        }
        if (!this.savedConnections.isEmpty()) {
            JSONArray devices = new JSONArray();
            for (ConnectionDTO connectionDTO : this.savedConnections) {
                if (connectionDTO == null || connectionDTO.getSourceType() == null) continue;
                JSONObject device = null;
                if (connectionDTO.getSourceType() == SourceType.bionet) {
                    device = this.createBionetDeviceConfig(connectionDTO.getHost(), connectionDTO.getTcpPort(), connectionDTO.getUdpPort());
                }
                if (Arrays.asList(SourceType.ek12t, SourceType.pe1201a, SourceType.axion, SourceType.fastecg, SourceType.fastecg_amp, SourceType.miniecg, SourceType.ucard).contains(connectionDTO.getSourceType())) {
                    device = this.createComDeviceConfig(connectionDTO.getSourceType(), connectionDTO.getPort());
                }
                if (connectionDTO.getSourceType() == SourceType.btl) {
                    device = this.createBtlConfig(connectionDTO.getPort(), connectionDTO.getKey());
                }
                if (connectionDTO.getSourceType() == SourceType.sapa) {
                    device = this.createSimpleConfig(connectionDTO.getSourceType());
                }
                if (device == null) continue;
                if (connectionDTO.getLastActive().booleanValue()) {
                    device.put((Object)"last", (Object)true);
                }
                devices.add((Object)device);
            }
            config.put((Object)"devices", (Object)devices);
        }
        try {
            FileWriter file = new FileWriter(CONFIG_FILE);
            Object object = null;
            try {
                file.write(config.toJSONString());
                file.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (file != null) {
                    if (object != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        file.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Could not save configuration file", (Throwable)e);
        }
    }

    private JSONObject createBionetDeviceConfig(String host, int tcpPort, int udpPort) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)String.valueOf(SourceType.bionet));
        jsonObject.put((Object)"host", (Object)host);
        jsonObject.put((Object)"tcpPort", (Object)String.valueOf(tcpPort));
        jsonObject.put((Object)"udpPort", (Object)String.valueOf(udpPort));
        return jsonObject;
    }

    private JSONObject createComDeviceConfig(SourceType sourceType, String port) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)String.valueOf(sourceType));
        jsonObject.put((Object)"port", (Object)port);
        return jsonObject;
    }

    private JSONObject createBtlConfig(String port, String key) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)String.valueOf(SourceType.btl));
        jsonObject.put((Object)"port", (Object)port);
        jsonObject.put((Object)"key", (Object)key);
        return jsonObject;
    }

    private JSONObject createSimpleConfig(SourceType sourceType) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)String.valueOf(sourceType));
        return jsonObject;
    }

    public String getInputSignal(String file) {
        return this.applicationConfig.getInputSignal(file);
    }

    public String getDefaultSignal() {
        return this.applicationConfig.getDefaultSignal();
    }

    public String getSignalsInputDirectory() {
        return this.applicationConfig.getSignalsInputDirectory();
    }

    public String getSignalsOutputDirectory() {
        return this.applicationConfig.getSignalsOutputDirectory();
    }
}

