/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import cmc.ecg.driver.DriverService;
import cmc.ecg.driver.device.ComPortsService;
import cmc.ecg.driver.dto.ConnectionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"ecg.scheduler.enable"})
public class DriverAutoConnectionScheduler {
    private static final Logger log = LoggerFactory.getLogger(DriverAutoConnectionScheduler.class);
    @Autowired
    private DriverService driverService;
    @Autowired
    private ComPortsService comPortsService;

    @Scheduled(fixedDelayString="${ecg.scheduler.fixed-delay}", initialDelayString="${ecg.scheduler.initial-delay}")
    public void autoConnect() {
        if (!this.driverService.getReconnect()) {
            log.trace("Reconnect is not active");
            return;
        }
        ConnectionDTO connectionDTO = this.driverService.getConnectionDTO();
        if (connectionDTO != null && connectionDTO.getSourceType() != null) {
            if (this.driverService.isConnectionAlive()) {
                log.trace("Connection is alive: {}", (Object)connectionDTO);
                return;
            }
            if (connectionDTO.getPortSetByUser().booleanValue()) {
                log.trace("Reconnect is active. Establishing connection to {}", (Object)connectionDTO);
                this.driverService.connect(connectionDTO);
            } else {
                String port = this.comPortsService.nextPort();
                if (port == null) {
                    log.trace("No serial ports found");
                    return;
                }
                log.trace("Establishing connection in auto port mode. Current port: {}", (Object)port);
                connectionDTO.setPort(port);
                this.driverService.connect(connectionDTO);
            }
        }
    }
}

