/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import cmc.ecg.driver.ConfigService;
import cmc.ecg.driver.DriverService;
import cmc.ecg.driver.device.ComPortsService;
import cmc.ecg.driver.dto.ConnectionDTO;
import cmc.ecg.driver.dto.MetaInfo;
import cmc.ecg.driver.dto.SignalDTO;
import cmc.ecg.driver.dto.SourceType;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DriverController {
    private static final Logger log = LoggerFactory.getLogger(DriverController.class);
    public static final String CONNECTION = "/connection";
    public static final String FS = "/fs";
    public static final String SIGNALS = "/signals";
    public static final String SOURCES = "/sources";
    public static final String PORTS = "/ports";
    public static final String AUTO_CONNECT = "\u0410\u0432\u0442\u043e\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435";
    public static final String AVAILABLE_DEVICES = "/devices";
    public static final String CURRENT_DEVICE = "/current_device";
    public static final String INFO = "/info";
    public static final String TOGGLE_NETWORK_DEVICE = "/devices/toggle/{state}";
    public static final String RECONNECT_NETWORK_DEVICE = "/reconnect_network_device";
    public static final String RECONNECT = "/reconnect";
    @Autowired
    private DriverService driverService;
    @Autowired
    private ComPortsService comPortsService;
    @Autowired
    private ConfigService configService;

    @GetMapping(value={"/sources"})
    public List<SourceType> getSourceTypes() {
        return Arrays.asList(SourceType.values());
    }

    @GetMapping(value={"/ports"})
    public List<String> getPorts() {
        LinkedList<String> ports = new LinkedList<String>();
        ports.add(AUTO_CONNECT);
        ports.addAll(this.comPortsService.getAllPorts());
        return ports;
    }

    @GetMapping(value={"/signals"})
    public List<SignalDTO> getSignals() throws IOException {
        return this.driverService.getSignals();
    }

    @GetMapping(value={"/connection"})
    public ConnectionDTO getConnection() {
        return this.driverService.getConnectionDTO();
    }

    @GetMapping(value={"/fs"})
    public Integer getFs() {
        return this.driverService.getFs();
    }

    @GetMapping(value={"/info"})
    public MetaInfo getInfo() {
        return this.driverService.getInfo();
    }

    @GetMapping(value={"/devices"})
    public List<ConnectionDTO> getAvailableDevices() {
        return this.driverService.getAvailableDevices();
    }

    @GetMapping(value={"/current_device"})
    public ConnectionDTO getConnectionDTO() {
        return this.driverService.getConnectionDTO();
    }

    @GetMapping(value={"/reconnect_network_device"})
    public Boolean getReconnect() {
        return this.driverService.getReconnect();
    }

    @PostMapping(value={"/devices/toggle/{state}"})
    public Boolean toggleState(@PathVariable Boolean state) {
        return this.driverService.toggleState(state);
    }

    @PostMapping(value={"/reconnect"})
    public void reconnect() {
        this.driverService.reconnect();
    }

    @PutMapping(value={"/connection"})
    public ConnectionDTO connect(@RequestBody ConnectionDTO newConnection) {
        if (newConnection.getSourceType() == SourceType.bionet) {
            newConnection.setPortSetByUser(Boolean.valueOf(true));
            newConnection.setPort(null);
        } else if (AUTO_CONNECT.equals(newConnection.getPort())) {
            newConnection.setPort("auto");
            newConnection.setPortSetByUser(Boolean.valueOf(false));
        } else {
            newConnection.setPortSetByUser(Boolean.valueOf(true));
        }
        this.configService.addConnection(newConnection);
        this.driverService.setConnectionDTO(newConnection);
        this.driverService.disconnect();
        return this.driverService.getConnectionDTO();
    }
}

