/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import java9.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DriverPushService
implements Flow.Subscriber<Double[]> {
    private static final Logger log = LoggerFactory.getLogger(DriverPushService.class);
    @Autowired
    private SimpMessagingTemplate template;
    private Flow.Subscription subscription;

    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(Double[] item) {
        this.template.convertAndSend((Object)"/signal", (Object)item);
        this.subscription.request(1L);
    }

    public void onError(Throwable throwable) {
        log.error("Error", throwable);
    }

    public void onComplete() {
        log.info("Subscription complete");
    }
}

