/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import cmc.ecg.driver.ConfigService;
import cmc.ecg.driver.DriverPushService;
import cmc.ecg.driver.DriverService;
import cmc.ecg.driver.device.ComPortsService;
import cmc.ecg.driver.device.Connection;
import cmc.ecg.driver.dto.ConnectionDTO;
import cmc.ecg.driver.dto.MetaInfo;
import cmc.ecg.driver.dto.SignalDTO;
import cmc.ecg.driver.dto.SourceType;
import cmc.ecg.driver.source.axion.AxionConnection;
import cmc.ecg.driver.source.bionet.BionetConnection;
import cmc.ecg.driver.source.btl.BTLConnection;
import cmc.ecg.driver.source.ek12t.EK12TConnection;
import cmc.ecg.driver.source.ek12t.EK12TFileConnection;
import cmc.ecg.driver.source.fastecg.FastecgConnection;
import cmc.ecg.driver.source.json.JsonFileConnection;
import cmc.ecg.driver.source.miniecg.MiniecgConnection;
import cmc.ecg.driver.source.pe1201a.PE1201AConnection;
import cmc.ecg.driver.source.sapa.SapaConnection;
import cmc.ecg.driver.source.ucard.UcardConnection;
import cmc.ecg.driver.utils.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java9.util.concurrent.Flow;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service
public class DriverService {
    private static final Logger log = LoggerFactory.getLogger(DriverService.class);
    @Autowired
    private DriverPushService pushService;
    @Autowired
    private DriverPushService secPushService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ComPortsService comPortsService;
    @Autowired
    private ResourcePatternResolver resourcePatternResolver;
    private ConnectionDTO connectionDTO;
    private Connection connection;
    private boolean reconnect = true;
    private int jsonFileFs = 0;

    @PostConstruct
    public void init() {
        try {
            Utils.checkOldLogs((String)"logs/");
            if (!Files.exists(Paths.get(this.configService.getSignalsOutputDirectory(), new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get(this.configService.getSignalsOutputDirectory(), new String[0]), new FileAttribute[0]);
            }
            log.info("Running version {}", (Object)this.getClass().getPackage().getImplementationVersion());
            this.connectionDTO = this.configService.getLastActiveConnection();
            log.info("Configured connection: {}", (Object)this.connectionDTO);
        }
        catch (Exception e) {
            log.warn("Exception in init block", (Throwable)e);
        }
    }

    public boolean getReconnect() {
        return this.reconnect;
    }

    public ConnectionDTO getConnectionDTO() {
        this.connectionDTO.setStatus(Boolean.valueOf(this.connection != null && this.connection.isReceivingData()));
        return this.configService.setLastInput(this.connectionDTO);
    }

    public void setConnectionDTO(ConnectionDTO newConnection) {
        log.info("New configured connection: {}", (Object)newConnection);
        this.connectionDTO = newConnection;
    }

    public List<SignalDTO> getSignals() throws IOException {
        SignalDTO signalDTO = new SignalDTO();
        signalDTO.setSourceType(SourceType.ek12t);
        Resource[] resources = this.resourcePatternResolver.getResources(this.configService.getSignalsInputDirectory() + "/*");
        signalDTO.setFiles(Arrays.stream(resources).map(Resource::getFilename).sorted().collect(Collectors.toList()));
        return Collections.singletonList(signalDTO);
    }

    public List<ConnectionDTO> getAvailableDevices() {
        ArrayList<ConnectionDTO> result = new ArrayList<ConnectionDTO>();
        List availablePorts = this.comPortsService.getAllPorts();
        log.trace("Available ports: {}", (Object)Arrays.toString(availablePorts.toArray()));
        for (ConnectionDTO connectionDto : this.configService.getSavedConnections()) {
            SourceType sourceType = connectionDto.getSourceType();
            if (Arrays.asList(SourceType.ek12t, SourceType.pe1201a, SourceType.btl, SourceType.axion, SourceType.fastecg, SourceType.fastecg_amp, SourceType.miniecg, SourceType.ucard).contains(sourceType)) {
                if (!availablePorts.contains(connectionDto.getPort())) continue;
                log.trace("Adding connection with port {}", (Object)connectionDto.getPort());
                result.add(connectionDto);
                continue;
            }
            if (sourceType != SourceType.bionet || !Utils.pingHost((String)connectionDto.getHost(), (int)connectionDto.getTcpPort(), (int)500)) continue;
            log.trace("Adding connection with host {}, TCP port {}", (Object)connectionDto.getHost(), (Object)connectionDto.getPort());
            result.add(connectionDto);
        }
        return result;
    }

    public synchronized void connect(ConnectionDTO newConnection) {
        this.connection = this.getConnection(newConnection, this.connection);
        this.connectionDTO = newConnection;
        this.connection.connect((Flow.Subscriber)this.pushService);
    }

    private Connection getConnection(ConnectionDTO newConnection, Connection currentConnection) {
        log.trace("Connecting to: {}", (Object)newConnection);
        if (currentConnection != null) {
            currentConnection.disconnect();
        }
        try {
            currentConnection = this.createConnection(newConnection);
        }
        catch (Exception e) {
            log.warn("Cannot connect to source {}", (Object)newConnection.getSource(), (Object)e);
        }
        return currentConnection;
    }

    public Integer getFs() {
        if (this.connectionDTO == null || this.connectionDTO.getSourceType() == null) {
            return 0;
        }
        if (this.connectionDTO.getSourceType() == SourceType.recorded_signal) {
            return this.jsonFileFs;
        }
        return this.connectionDTO.getSourceType().getFs();
    }

    public MetaInfo getInfo() {
        if (this.connectionDTO == null) {
            return null;
        }
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.setSource(this.connectionDTO.getSourceType());
        metaInfo.setFs(this.getFs());
        metaInfo.setVersion(this.getClass().getPackage().getImplementationVersion());
        metaInfo.setStatus(Boolean.valueOf(this.connection != null && this.connection.isReceivingData()));
        return metaInfo;
    }

    public synchronized void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public synchronized void reconnect() {
        if (this.connectionDTO.getSourceType() == SourceType.btl && this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    private Connection createConnection(ConnectionDTO dto) throws IOException {
        switch (1.$SwitchMap$cmc$ecg$driver$dto$SourceType[dto.getSourceType().ordinal()]) {
            case 1: {
                return new EK12TConnection(dto.getPort(), dto.getSendSignal());
            }
            case 2: {
                return new EK12TFileConnection(this.resourcePatternResolver.getResource(this.configService.getInputSignal(this.configService.getDefaultSignal())).getInputStream(), dto.getSendSignal());
            }
            case 3: {
                return new EK12TFileConnection(this.resourcePatternResolver.getResource(this.configService.getInputSignal(dto.getSource())).getInputStream(), dto.getSendSignal());
            }
            case 4: {
                return new BionetConnection(dto.getHost(), dto.getTcpPort(), dto.getUdpPort());
            }
            case 5: {
                return new PE1201AConnection(dto.getPort(), dto.getSendSignal());
            }
            case 6: {
                return new BTLConnection(dto.getPort(), dto.getSendSignal(), dto.getKey());
            }
            case 7: {
                return new AxionConnection(dto.getPort(), dto.getSendSignal());
            }
            case 8: {
                return new FastecgConnection(dto.getPort(), dto.getSendSignal(), false);
            }
            case 9: {
                return new FastecgConnection(dto.getPort(), dto.getSendSignal(), true);
            }
            case 10: {
                return new MiniecgConnection(dto.getPort(), dto.getSendSignal());
            }
            case 11: {
                return new SapaConnection();
            }
            case 12: {
                return new UcardConnection(dto.getPort(), dto.getSendSignal());
            }
            case 13: {
                byte[] bytes = Base64.getDecoder().decode(dto.getSource().getBytes());
                JsonFileConnection jsonFileConnection = new JsonFileConnection(new String(bytes));
                this.jsonFileFs = jsonFileConnection.getFs();
                return jsonFileConnection;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isConnectionAlive() {
        return this.connection != null && this.connection.isAlive();
    }

    public Boolean toggleState(Boolean state) {
        log.info("Device toggle: {}", (Object)state);
        if (!state.booleanValue()) {
            this.disconnect();
        }
        this.reconnect = state;
        return this.reconnect;
    }
}

