/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import cmc.ecg.driver.UpdateService;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component
public class Tray {
    private static final Logger log = LoggerFactory.getLogger(Tray.class);
    @Autowired
    private UpdateService updateService;
    @Autowired
    private ResourcePatternResolver resourcePatternResolver;

    @PostConstruct
    public void createTrayIcon() {
        if (!SystemTray.isSupported()) {
            log.info("System tray is not supported");
            return;
        }
        try {
            SystemTray tray = SystemTray.getSystemTray();
            PopupMenu popupMenu = new PopupMenu();
            Image trayImage = new ImageIcon(StreamUtils.copyToByteArray((InputStream)this.resourcePatternResolver.getResource("classpath:/trayicon.png").getInputStream())).getImage();
            Dimension trayIconSize = tray.getTrayIconSize();
            TrayIcon trayIcon = new TrayIcon(trayImage.getScaledInstance(trayIconSize.width, trayIconSize.height, 4), "SmartECG Driver " + this.getClass().getPackage().getImplementationVersion());
            MenuItem checkForUpdateItem = new MenuItem("Check for update");
            MenuItem settingsItem = new MenuItem("Settings");
            MenuItem exitItem = new MenuItem("Exit");
            checkForUpdateItem.addActionListener(l -> this.updateService.checkForUpdate());
            settingsItem.addActionListener(l -> {
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI("https://localhost:20000"));
                    }
                }
                catch (Exception e) {
                    log.info("Settings page could not be opened");
                }
            });
            exitItem.addActionListener(l -> System.exit(0));
            popupMenu.add(checkForUpdateItem);
            popupMenu.add(settingsItem);
            popupMenu.add(exitItem);
            trayIcon.setPopupMenu(popupMenu);
            tray.add(trayIcon);
        }
        catch (IOException e) {
            log.error("Tray icon image could not be loaded");
        }
        catch (AWTException e) {
            log.error("Tray icon could not be added");
        }
    }
}

