/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
@Configuration
public class UpdateService {
    private static final Logger log = LoggerFactory.getLogger(UpdateService.class);
    @Value(value="${ecg.download-driver-url}")
    private String downloadDriverUrl;
    @Value(value="${ecg.download-version-url}")
    private String downloadVersionUrl;

    public void checkForUpdate() {
        log.info("Checking for update");
        this.downloadFile(this.downloadVersionUrl, "version.txt", () -> this.checkVersion());
    }

    private void checkVersion() {
        try {
            String currentVersion = this.getClass().getPackage().getImplementationVersion();
            String newVersion = new String(Files.readAllBytes(Paths.get("version.txt", new String[0])));
            log.info("Current version: {}. Version from update server: {}", (Object)currentVersion, (Object)newVersion);
            if (this.isNewer(newVersion, currentVersion)) {
                this.update();
            }
        }
        catch (IOException e) {
            log.error("Could not read version from file", (Throwable)e);
        }
    }

    private void update() {
        log.info("Updating");
        this.downloadFile(this.downloadDriverUrl, "smartecg-new.jar", () -> this.restart());
    }

    private void downloadFile(String url, String fileName, Runnable onComplete) {
        Flux dataBufferFlux = WebClient.create((String)url).get().accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM}).retrieve().bodyToFlux(DataBuffer.class);
        try {
            if (Files.notExists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(fileName, new String[0]), new FileAttribute[0]);
            }
            DataBufferUtils.write((Publisher)dataBufferFlux, (WritableByteChannel)Files.newByteChannel(Paths.get(fileName, new String[0]), StandardOpenOption.WRITE)).map(DataBufferUtils::release).doOnComplete(onComplete).doOnError(e -> log.error("Error when downloading file", e)).subscribe();
        }
        catch (IOException e2) {
            log.error("Could not write file", (Throwable)e2);
        }
    }

    private void restart() {
        try {
            Runtime.getRuntime().exec("jre\\bin\\java -jar ecg-driver-installer.jar -update");
            System.exit(0);
        }
        catch (IOException e) {
            log.error("Could not run update process");
        }
    }

    private boolean isNewer(String newVersion, String currentVersion) {
        String[] newVersionParsed = newVersion.split("\\.");
        String[] currentVersionParsed = currentVersion.split("\\.");
        for (int i = 0; i < Math.min(newVersionParsed.length, currentVersionParsed.length); ++i) {
            try {
                int newInt = Integer.parseInt(newVersionParsed[i]);
                int currentInt = Integer.parseInt(currentVersionParsed[i]);
                if (newInt == currentInt) continue;
                return newInt > currentInt;
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse version");
                return false;
            }
        }
        return false;
    }
}

