/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver;

import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    public static final String MANAGE = "/manage";
    public static final String SIGNAL = "/signal";

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker(new String[]{SIGNAL});
        registry.setApplicationDestinationPrefixes(new String[]{MANAGE});
        registry.setPreservePublishOrder(true);
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/smartecg"}).setAllowedOrigins(new String[]{"http://localhost:5173", "http://localhost:9000", "https://smartecg-test.cmctech.pro", "https://frontend2-smartecg-test.cmctech.pro", "https://smartecg.kz"}).withSockJS();
    }
}

