/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.device;

import cmc.ecg.driver.utils.Utils;
import java.util.Arrays;
import java9.util.concurrent.SubmissionPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataProcessor<T>
extends SubmissionPublisher<Double[]> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataProcessor.class);

    public abstract void process(T var1);

    public int submit(Double[] signal) {
        if (signal == null || signal.length == 0) {
            log.trace("Skipping non signal data {}", (Object)Arrays.toString((Object[])signal));
            return 0;
        }
        for (int i = 0; i < signal.length; ++i) {
            signal[i] = Utils.round3((double)signal[i]);
        }
        log.trace("Sending signal: {}", (Object)Arrays.toString((Object[])signal));
        return super.submit((Object)signal);
    }
}

