/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.device;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.ComPortOptions;
import cmc.ecg.driver.device.RealTimeConnection;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import java9.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComPortConnection
extends RealTimeConnection {
    private static final Logger log = LoggerFactory.getLogger(ComPortConnection.class);
    private final ComPortOptions options;
    protected SerialPort comPort;
    private final AbstractDataProcessor<byte[]> processor;

    public ComPortConnection(ComPortOptions options, AbstractDataProcessor<byte[]> processor) {
        this.options = options;
        this.processor = processor;
    }

    public void connect() {
        SerialPort[] commPorts;
        log.trace("Connecting to serial port: {}", (Object)this.options.port);
        for (SerialPort port : commPorts = SerialPort.getCommPorts()) {
            if (!port.getDescriptivePortName().equals(this.options.port)) continue;
            this.comPort = port;
        }
        if (this.comPort == null) {
            log.info("There is no port available. Failed to connect");
        } else {
            this.comPort.setComPortParameters(this.options.getBaudRate(), this.options.getDataBits(), this.options.getStopBits(), this.options.getParityBits());
            log.trace("Connected to serial port: {} ({})", (Object)this.comPort.getDescriptivePortName(), (Object)this.comPort.getSystemPortName());
            log.trace("Opening port: {}", (Object)this.comPort.getDescriptivePortName());
            this.comPort.openPort();
            log.trace("Opened port: {}", (Object)this.comPort.getDescriptivePortName());
            this.addDataProcessor(this.processor);
        }
    }

    public void connect(Flow.Subscriber<Double[]> subscriber) {
        this.processor.subscribe(subscriber);
        this.connect();
    }

    public void disconnect() {
        log.trace("Disconnecting from serial port");
        if (this.comPort == null) {
            log.trace("No serial port connection exists");
            return;
        }
        this.comPort.closePort();
        this.comPort = null;
    }

    void addDataProcessor(AbstractDataProcessor<byte[]> processor) {
        this.comPort.removeDataListener();
        this.comPort.addDataListener((SerialPortDataListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected String getInfo() {
        return this.options.port;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

