/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.device;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.ComPortDataConverter;
import cmc.ecg.driver.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComPortDataProcessor
extends AbstractDataProcessor<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(ComPortDataProcessor.class);
    protected final List<Byte> buffer = new ArrayList();
    protected ComPortDataConverter converter;
    private final Boolean sendSignal;

    public ComPortDataProcessor(Boolean send) {
        this.sendSignal = send;
    }

    public synchronized void process(byte[] data) {
        Utils.concat((List)this.buffer, (byte[])data);
        if (!this.selectConverter()) {
            return;
        }
        while (this.converter.hasNext()) {
            if (this.sendSignal.booleanValue()) {
                this.submit(this.converter.next());
                continue;
            }
            this.converter.next();
        }
    }

    protected abstract boolean selectConverter();
}

