/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.device;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.Connection;
import java9.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileConnection<T>
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(FileConnection.class);
    protected final AbstractDataProcessor<T> processor;
    protected volatile boolean connected;

    public FileConnection(AbstractDataProcessor<T> processor) {
        this.processor = processor;
    }

    public void connect() {
        this.connected = true;
        new Thread(() -> this.process()).start();
    }

    public void connect(Flow.Subscriber<Double[]> subscriber) {
        this.processor.subscribe(subscriber);
        this.connect();
    }

    protected abstract void processOnce();

    private void process() {
        while (this.connected) {
            this.processOnce();
        }
    }

    public void disconnect() {
        this.connected = false;
    }

    public boolean isAlive() {
        return this.connected;
    }

    public boolean isReceivingData() {
        return this.connected;
    }
}

