/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.device;

import cmc.ecg.driver.device.AbstractDataProcessor;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriterDataProcessor
extends AbstractDataProcessor<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(FileWriterDataProcessor.class);
    private final String fileName;
    private final FileOutputStream writer;

    public FileWriterDataProcessor(String fileName) {
        this.fileName = fileName;
        try {
            this.writer = new FileOutputStream(fileName);
        }
        catch (IOException e) {
            log.error("Can not open ek12t_file {}", (Object)fileName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void process(byte[] data) {
        try {
            this.writer.write(data);
        }
        catch (IOException e) {
            log.error("Error occurred while writing to ek12t_file {}", (Object)this.fileName);
            throw new RuntimeException(e);
        }
    }
}

