/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.device;

import cmc.ecg.driver.device.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RealTimeConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(RealTimeConnection.class);
    protected volatile long lastTimeDataReceived = 0L;

    public boolean isAlive() {
        return this.isReceivingData();
    }

    public boolean isReceivingData() {
        boolean isReceivingData;
        boolean bl = isReceivingData = System.currentTimeMillis() - this.lastTimeDataReceived < 1000L;
        if (this.lastTimeDataReceived != 0L && !isReceivingData) {
            log.info("Data flow stopped ({})", (Object)this.getInfo());
        }
        return isReceivingData;
    }

    protected void registerDataReceived() {
        if (this.lastTimeDataReceived == 0L) {
            log.info("Data flow started ({})", (Object)this.getInfo());
        }
        this.lastTimeDataReceived = System.currentTimeMillis();
    }

    protected abstract String getInfo();
}

