/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.dto;

import cmc.ecg.driver.dto.ConnectionDTO;
import cmc.ecg.driver.dto.SourceType;
import java.util.Arrays;
import java.util.Objects;

public class ConnectionDTO {
    private Boolean status;
    private SourceType sourceType;
    private String port;
    private String host;
    private int tcpPort;
    private int udpPort;
    private String key;
    private String source;
    private DestinationType destinationType;
    private String destination;
    private Boolean portSetByUser = false;
    private Boolean sendSignal = true;
    private Boolean lastActive = false;

    public ConnectionDTO() {
        this(null);
    }

    public ConnectionDTO(SourceType sourceType) {
        this(sourceType, DestinationType.websocket);
    }

    public ConnectionDTO(SourceType sourceType, DestinationType destinationType) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.status = false;
    }

    public boolean isEqual(ConnectionDTO connectionDTO) {
        if (connectionDTO == this) {
            return true;
        }
        if (this.sourceType != connectionDTO.sourceType) {
            return false;
        }
        if (this.sourceType == SourceType.sapa) {
            return true;
        }
        if (Arrays.asList(SourceType.ek12t, SourceType.pe1201a, SourceType.axion, SourceType.fastecg, SourceType.fastecg_amp, SourceType.miniecg, SourceType.ucard).contains(this.sourceType)) {
            return Objects.equals(this.port, connectionDTO.port);
        }
        if (this.sourceType == SourceType.btl) {
            return Objects.equals(this.port, connectionDTO.port) && Objects.equals(this.key, connectionDTO.key);
        }
        if (this.sourceType == SourceType.bionet) {
            return Objects.equals(this.host, connectionDTO.host) && this.tcpPort == connectionDTO.tcpPort && this.udpPort == connectionDTO.udpPort;
        }
        return false;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public String getKey() {
        return this.key;
    }

    public String getSource() {
        return this.source;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getDestination() {
        return this.destination;
    }

    public Boolean getPortSetByUser() {
        return this.portSetByUser;
    }

    public Boolean getSendSignal() {
        return this.sendSignal;
    }

    public Boolean getLastActive() {
        return this.lastActive;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public void setUdpPort(int udpPort) {
        this.udpPort = udpPort;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setPortSetByUser(Boolean portSetByUser) {
        this.portSetByUser = portSetByUser;
    }

    public void setSendSignal(Boolean sendSignal) {
        this.sendSignal = sendSignal;
    }

    public void setLastActive(Boolean lastActive) {
        this.lastActive = lastActive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionDTO)) {
            return false;
        }
        ConnectionDTO other = (ConnectionDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTcpPort() != other.getTcpPort()) {
            return false;
        }
        if (this.getUdpPort() != other.getUdpPort()) {
            return false;
        }
        Boolean this$status = this.getStatus();
        Boolean other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$portSetByUser = this.getPortSetByUser();
        Boolean other$portSetByUser = other.getPortSetByUser();
        if (this$portSetByUser == null ? other$portSetByUser != null : !((Object)this$portSetByUser).equals(other$portSetByUser)) {
            return false;
        }
        Boolean this$sendSignal = this.getSendSignal();
        Boolean other$sendSignal = other.getSendSignal();
        if (this$sendSignal == null ? other$sendSignal != null : !((Object)this$sendSignal).equals(other$sendSignal)) {
            return false;
        }
        Boolean this$lastActive = this.getLastActive();
        Boolean other$lastActive = other.getLastActive();
        if (this$lastActive == null ? other$lastActive != null : !((Object)this$lastActive).equals(other$lastActive)) {
            return false;
        }
        SourceType this$sourceType = this.getSourceType();
        SourceType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        DestinationType this$destinationType = this.getDestinationType();
        DestinationType other$destinationType = other.getDestinationType();
        if (this$destinationType == null ? other$destinationType != null : !this$destinationType.equals(other$destinationType)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTcpPort();
        result = result * 59 + this.getUdpPort();
        Boolean $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $portSetByUser = this.getPortSetByUser();
        result = result * 59 + ($portSetByUser == null ? 43 : ((Object)$portSetByUser).hashCode());
        Boolean $sendSignal = this.getSendSignal();
        result = result * 59 + ($sendSignal == null ? 43 : ((Object)$sendSignal).hashCode());
        Boolean $lastActive = this.getLastActive();
        result = result * 59 + ($lastActive == null ? 43 : ((Object)$lastActive).hashCode());
        SourceType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        DestinationType $destinationType = this.getDestinationType();
        result = result * 59 + ($destinationType == null ? 43 : $destinationType.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionDTO(status=" + this.getStatus() + ", sourceType=" + this.getSourceType() + ", port=" + this.getPort() + ", host=" + this.getHost() + ", tcpPort=" + this.getTcpPort() + ", udpPort=" + this.getUdpPort() + ", key=" + this.getKey() + ", source=" + this.getSource() + ", destinationType=" + this.getDestinationType() + ", destination=" + this.getDestination() + ", portSetByUser=" + this.getPortSetByUser() + ", sendSignal=" + this.getSendSignal() + ", lastActive=" + this.getLastActive() + ")";
    }
}

