/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.axion;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.ComPortConnection;
import cmc.ecg.driver.device.ComPortOptions;
import cmc.ecg.driver.source.axion.AxionComPortOptions;
import cmc.ecg.driver.source.axion.AxionDataProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxionConnection
extends ComPortConnection {
    private static final Logger log = LoggerFactory.getLogger(AxionConnection.class);
    private static final byte START = 90;

    public AxionConnection(String port, Boolean sendSignal) {
        super((ComPortOptions)new AxionComPortOptions(port), (AbstractDataProcessor)new AxionDataProcessor(sendSignal));
    }

    public void connect() {
        super.connect();
        if (this.comPort != null) {
            this.comPort.writeBytes(new byte[]{90}, 1);
            byte[] answer = new byte[7];
            this.comPort.readBytes(answer, 7);
            String answerString = new String(answer);
            if (!"CONFIRM".equals(answerString)) {
                log.error("Axion didn't confirm connection");
            }
        }
    }
}

