/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.axion;

import cmc.ecg.driver.device.ComPortDataConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AxionDataConverter
extends ComPortDataConverter {
    private static final int PACKET_SIZE = 24;
    private static final byte HEADER1 = -16;
    private static final byte HEADER2 = 15;
    private static final List<Byte> HEADER_LIST = Arrays.asList((byte)-16, (byte)15);

    public AxionDataConverter(List<Byte> data) {
        super(data);
    }

    public boolean hasNext() {
        int headerListIndex = Collections.indexOfSubList(this.buffer, HEADER_LIST);
        return headerListIndex > -1 && this.buffer.size() >= headerListIndex + 24;
    }

    public Double[] next() {
        int packetStart = Collections.indexOfSubList(this.buffer, HEADER_LIST);
        ArrayList packet = new ArrayList(this.buffer.subList(packetStart, packetStart + 24));
        this.clear(packetStart + 24);
        Double[] result = new Double[12];
        result[1] = this.getValue(((Byte)packet.get(10)).byteValue(), ((Byte)packet.get(11)).byteValue());
        result[2] = this.getValue(((Byte)packet.get(8)).byteValue(), ((Byte)packet.get(9)).byteValue());
        result[0] = result[1] - result[2];
        result[3] = result[2] / 2.0 - result[1];
        result[4] = result[1] / 2.0 - result[2];
        result[5] = (result[1] + result[2]) / 2.0;
        for (int i = 6; i < 12; ++i) {
            result[i] = (result[1] + result[2]) / 3.0 - this.getValue(((Byte)packet.get(2 * i)).byteValue(), ((Byte)packet.get(2 * i + 1)).byteValue());
        }
        return result;
    }

    private double getValue(byte b1, byte b2) {
        return (double)((short)((b2 & 0xFF) << 8 | b1 & 0xFF) * 3) / 2000.0;
    }
}

