/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.bionet;

import cmc.ecg.driver.device.RealTimeConnection;
import cmc.ecg.driver.source.bionet.BionetConnection;
import cmc.ecg.driver.source.bionet.BionetDataProcessor;
import java.net.DatagramSocket;
import java.net.Socket;
import java9.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BionetConnection
extends RealTimeConnection {
    private static final Logger log = LoggerFactory.getLogger(BionetConnection.class);
    private static final int TIMEOUT = 5000;
    private final BionetDataProcessor processor;
    private final String host;
    private final int tcpPort;
    private final int udpPort;
    private IOThread ioThread;
    private Socket socket;
    private DatagramSocket datagramSocket;

    public BionetConnection(String host, int tcpPort, int udpPort) {
        this.host = host;
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
        this.processor = new BionetDataProcessor();
    }

    public void connect(Flow.Subscriber<Double[]> subscriber) {
        this.processor.subscribe(subscriber);
        this.ioThread = new IOThread(this, null);
        this.ioThread.start();
    }

    public void disconnect() {
        this.ioThread.stopThread();
    }

    public boolean isAlive() {
        return this.ioThread.isAlive();
    }

    protected String getInfo() {
        return "Host: " + this.host + ", TCP port: " + this.tcpPort + ", UDP port: " + this.udpPort;
    }

    static /* synthetic */ String access$100(BionetConnection x0) {
        return x0.host;
    }

    static /* synthetic */ int access$200(BionetConnection x0) {
        return x0.tcpPort;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ Socket access$402(BionetConnection x0, Socket x1) {
        x0.socket = x1;
        return x0.socket;
    }

    static /* synthetic */ Socket access$400(BionetConnection x0) {
        return x0.socket;
    }

    static /* synthetic */ DatagramSocket access$502(BionetConnection x0, DatagramSocket x1) {
        x0.datagramSocket = x1;
        return x0.datagramSocket;
    }

    static /* synthetic */ DatagramSocket access$500(BionetConnection x0) {
        return x0.datagramSocket;
    }

    static /* synthetic */ int access$600(BionetConnection x0) {
        return x0.udpPort;
    }

    static /* synthetic */ void access$700(BionetConnection x0) {
        x0.registerDataReceived();
    }

    static /* synthetic */ BionetDataProcessor access$800(BionetConnection x0) {
        return x0.processor;
    }
}

