/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.bionet;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BionetDataConverter {
    private static final Logger log = LoggerFactory.getLogger(BionetDataConverter.class);
    private final List<Byte> buffer;

    public BionetDataConverter(List<Byte> buffer) {
        this.buffer = buffer;
    }

    public Double[] next() {
        ArrayList packet = new ArrayList(this.buffer.subList(0, 16));
        this.buffer.subList(0, 16).clear();
        double I = this.getValue(((Byte)packet.get(0)).byteValue(), ((Byte)packet.get(1)).byteValue());
        double II = this.getValue(((Byte)packet.get(2)).byteValue(), ((Byte)packet.get(3)).byteValue());
        double III = II - I;
        double aVR = -II + 0.5 * III;
        double aVL = -III + 0.5 * II;
        double aVF = III + 0.5 * I;
        double V1 = this.getValue(((Byte)packet.get(4)).byteValue(), ((Byte)packet.get(5)).byteValue());
        double V2 = this.getValue(((Byte)packet.get(6)).byteValue(), ((Byte)packet.get(7)).byteValue());
        double V3 = this.getValue(((Byte)packet.get(8)).byteValue(), ((Byte)packet.get(9)).byteValue());
        double V4 = this.getValue(((Byte)packet.get(10)).byteValue(), ((Byte)packet.get(11)).byteValue());
        double V5 = this.getValue(((Byte)packet.get(12)).byteValue(), ((Byte)packet.get(13)).byteValue());
        double V6 = this.getValue(((Byte)packet.get(14)).byteValue(), ((Byte)packet.get(15)).byteValue());
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }

    private double getValue(byte b1, byte b2) {
        return (double)((short)((b1 & 0xFF) << 8 | b2 & 0xFF)) / 306.0;
    }
}

