/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.btl;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.ComPortConnection;
import cmc.ecg.driver.device.ComPortOptions;
import cmc.ecg.driver.source.btl.BTLComPortOptions;
import cmc.ecg.driver.source.btl.BTLDataProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTLConnection
extends ComPortConnection {
    private static final Logger log = LoggerFactory.getLogger(BTLConnection.class);
    private static final byte START = -86;
    private static final byte KEEPALIVE = -128;
    private static final byte STOP = -85;
    private long lastTimeKeepAliveSignalSent = 0L;

    public BTLConnection(String port, Boolean sendSignal, String key) {
        super((ComPortOptions)new BTLComPortOptions(port), (AbstractDataProcessor)new BTLDataProcessor(sendSignal, key));
    }

    public void connect() {
        super.connect();
        if (this.comPort != null) {
            this.comPort.writeBytes(new byte[]{-85}, 1);
            this.comPort.writeBytes(new byte[]{-86}, 1);
        }
        this.lastTimeKeepAliveSignalSent = System.currentTimeMillis();
    }

    public void disconnect() {
        if (this.comPort != null) {
            this.comPort.writeBytes(new byte[]{-85}, 1);
        }
        super.disconnect();
    }

    protected void registerDataReceived() {
        super.registerDataReceived();
        if (this.lastTimeDataReceived - this.lastTimeKeepAliveSignalSent > 500L) {
            log.trace("Sending keepalive signal");
            this.lastTimeKeepAliveSignalSent = System.currentTimeMillis();
            if (this.comPort != null) {
                this.comPort.writeBytes(new byte[]{-128}, 1);
            }
        }
    }
}

