/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.btl;

import cmc.ecg.driver.device.ComPortDataConverter;
import cmc.ecg.driver.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BTLDataConverter
extends ComPortDataConverter {
    private static final Logger log = LoggerFactory.getLogger(BTLDataConverter.class);
    private final byte[] key;

    public BTLDataConverter(List<Byte> data, String key) {
        super(data);
        if (key == null || key.length() < 2) {
            throw new IllegalArgumentException();
        }
        int leadingZeroes = key.startsWith("0x") ? 18 - key.length() : 16 - key.length();
        String hex = key.startsWith("0x") ? key.substring(2) : key;
        this.key = DatatypeConverter.parseHexBinary((String)String.join((CharSequence)"", Collections.nCopies(leadingZeroes, "0")).concat(hex));
        log.trace("Key: {}", (Object)this.key);
    }

    protected abstract int getPacketLength();

    public boolean hasNext() {
        int packetStart = Utils.indexOfTwoNegativeBytes((List)this.buffer);
        if (packetStart == -1 || this.buffer.size() < packetStart + this.getPacketLength()) {
            return false;
        }
        this.clear(packetStart);
        return true;
    }

    public Double[] next() {
        ArrayList packet = new ArrayList(this.buffer.subList(0, this.getPacketLength()));
        this.clear(this.getPacketLength());
        if ((Byte)packet.get(0) == -48 && (Byte)packet.get(1) == -48) {
            log.trace("Skipping control packet");
            return new Double[0];
        }
        if (!this.isValid(packet)) {
            log.trace("Skipping invalid packet: {}", packet);
            return new Double[0];
        }
        Double[] result = new Double[12];
        for (int i = 0; i < 8; ++i) {
            result[i > 1 ? i + 4 : i + 1] = (double)((((Byte)packet.get(i * 2) ^ this.key[i]) & 0x7F | (((Byte)packet.get(i * 2 + 1) ^ this.key[i]) & 0x7F) << 7) * 2 - 16384) / 1000.0;
        }
        result[0] = result[1] - result[2];
        result[3] = result[2] / 2.0 - result[1];
        result[4] = result[1] / 2.0 - result[2];
        result[5] = (result[1] + result[2]) / 2.0;
        return result;
    }

    protected abstract boolean isValid(List<Byte> var1);

    protected boolean hasValidData(List<Byte> packet) {
        for (int i = 2; i < 16; ++i) {
            if (packet.get(i) >= 0) continue;
            return false;
        }
        return true;
    }
}

