/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.btl;

import cmc.ecg.driver.device.ComPortDataProcessor;
import cmc.ecg.driver.source.btl.BTLLTDataConverter;
import cmc.ecg.driver.source.btl.BTLMTDataConverter;
import cmc.ecg.driver.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTLDataProcessor
extends ComPortDataProcessor {
    private static final Logger log = LoggerFactory.getLogger(BTLDataProcessor.class);
    private final String key;

    public BTLDataProcessor(Boolean send, String key) {
        super(send);
        this.key = key;
    }

    protected boolean selectConverter() {
        if (this.converter == null) {
            int packetStart = Utils.indexOfTwoNegativeBytes((List)this.buffer);
            if (packetStart == -1 || this.buffer.size() < packetStart + 17) {
                return false;
            }
            try {
                this.converter = (Byte)this.buffer.get(packetStart + 16) < 0 ? new BTLMTDataConverter(this.buffer, this.key) : new BTLLTDataConverter(this.buffer, this.key);
            }
            catch (IllegalArgumentException e) {
                log.error("Invalid key format", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

