/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.ek12t;

import cmc.ecg.driver.device.ComPortDataConverter;
import java.util.ArrayList;
import java.util.List;

public abstract class EK12TAbstractDataConverter
extends ComPortDataConverter {
    private static final int ADC_ZERO = 2048;
    private static final double LOW_ORDER_PRICE = 0.00478;
    protected int packetStart = 0;
    protected int packetEnd = 0;

    public EK12TAbstractDataConverter(List<Byte> data) {
        super(data);
    }

    protected double adc2volt(int adc) {
        return (double)(adc - 2048) * 0.00478;
    }

    public abstract boolean canParse();

    protected abstract Byte getPacketEnd();

    public boolean hasNext() {
        try {
            int next = this.buffer.subList(this.packetStart, this.buffer.size()).indexOf(this.getPacketEnd());
            this.packetEnd = this.packetStart + next;
            return next > -1;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    protected List<Byte> getNextRawPacket() {
        ArrayList<Byte> packet = new ArrayList<Byte>(this.buffer.subList(this.packetStart, this.packetEnd + 1));
        int toBeRemoved = this.packetEnd + 1;
        this.clear(toBeRemoved);
        this.packetEnd -= toBeRemoved;
        return packet;
    }
}

