/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.ek12t;

import cmc.ecg.driver.device.ComPortDataProcessor;
import cmc.ecg.driver.source.ek12t.EK12TRealTimeDataConverter;
import cmc.ecg.driver.source.ek12t.EK12TRecordedDataConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EK12TDataProcessor
extends ComPortDataProcessor {
    private static final Logger log = LoggerFactory.getLogger(EK12TDataProcessor.class);

    public EK12TDataProcessor(Boolean send) {
        super(send);
    }

    protected boolean selectConverter() {
        EK12TRecordedDataConverter recordedDataConverter = new EK12TRecordedDataConverter(this.buffer);
        EK12TRealTimeDataConverter realTimeDataConverter = new EK12TRealTimeDataConverter(this.buffer);
        boolean isRealTime = realTimeDataConverter.canParse();
        boolean isRecorded = recordedDataConverter.canParse();
        if (isRealTime && isRecorded) {
            if (this.converter != null) {
                while (this.converter.hasNext()) {
                    this.converter.next();
                }
            }
            return false;
        }
        if (isRealTime) {
            if (this.converter == null || this.converter instanceof EK12TRecordedDataConverter) {
                this.converter = realTimeDataConverter;
                log.info("Converter changed to {}", (Object)this.converter.getClass().getSimpleName());
            }
            return true;
        }
        if (isRecorded) {
            if (this.converter == null || this.converter instanceof EK12TRealTimeDataConverter) {
                this.converter = recordedDataConverter;
                log.info("Converter changed to {}", (Object)this.converter.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }
}

