/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.ek12t;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.FileConnection;
import cmc.ecg.driver.source.ek12t.EK12TDataProcessor;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class EK12TFileConnection
extends FileConnection<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(EK12TFileConnection.class);
    private byte[] fileContent;

    public EK12TFileConnection(InputStream inputStream, Boolean sendSignal) {
        super((AbstractDataProcessor)new EK12TDataProcessor(sendSignal));
        try {
            this.fileContent = StreamUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("Error while reading EK12T file", (Throwable)e);
        }
    }

    protected void processOnce() {
        try {
            long lastTime = System.currentTimeMillis();
            int currentPos = 0;
            int counter = 0;
            while (currentPos < this.fileContent.length && this.connected) {
                int length = currentPos + 61 < this.fileContent.length ? 61 : this.fileContent.length - currentPos;
                byte[] buffer = new byte[length];
                System.arraycopy(this.fileContent, currentPos, buffer, 0, length);
                currentPos += length;
                this.processor.process((Object)buffer);
                if (++counter % 4 != 0) continue;
                long currentTime = System.currentTimeMillis();
                long sleepInterval = 10L - currentTime + lastTime;
                if (sleepInterval > 0L) {
                    Thread.sleep(sleepInterval);
                }
                lastTime = currentTime + sleepInterval;
            }
        }
        catch (Exception e) {
            log.error("Error while processing EK12T file", (Throwable)e);
        }
    }
}

