/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.ek12t;

import cmc.ecg.driver.source.ek12t.EK12TAbstractDataConverter;
import cmc.ecg.driver.utils.Utils;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EK12TRealTimeDataConverter
extends EK12TAbstractDataConverter {
    private static final Logger log = LoggerFactory.getLogger(EK12TRealTimeDataConverter.class);
    private static final byte PACKET_START = 60;
    private static final byte PACKET_END = 62;
    private int[] leadBreak = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private double[] p_U = new double[9];
    private int connectionByte;

    public EK12TRealTimeDataConverter(List<Byte> data) {
        super(data);
    }

    protected Byte getPacketEnd() {
        return (byte)62;
    }

    public boolean canParse() {
        return this.buffer.contains((byte)60) && this.buffer.contains((byte)62);
    }

    public Double[] next() {
        List packet = this.getNextRawPacket();
        Double[] result = new Double[]{};
        if (packet == null || packet.size() != 18) {
            log.trace("Invalid packet: {}", packet == null ? null : Arrays.toString(packet.toArray()));
            return result;
        }
        byte byte0 = (Byte)packet.get(0);
        byte byte17 = (Byte)packet.get(17);
        if (byte0 != 60 && byte17 != 62) {
            log.trace("Invalid packet: {}", packet == null ? null : Arrays.toString(packet.toArray()));
            return result;
        }
        log.trace("Converting packet: {}", (Object)Arrays.toString(packet.toArray()));
        packet = Utils.slice((List)packet, (int)1, (int)17);
        Byte[] bytes = packet.toArray(new Byte[packet.size()]);
        String hex = DatatypeConverter.printHexBinary((byte[])this.toPrimitive(bytes));
        this.connectionByte = Integer.parseInt(String.valueOf(hex.charAt(0)), 16);
        if (!this.connected(this.connectionByte)) {
            log.trace("Disconnected leads C1, C5, C4, or C3. Check lead connectivity.");
        }
        hex = hex.substring(1);
        double[] U = new double[9];
        U[1] = this.adc2volt(Integer.parseInt(hex.substring(0, 3), 16));
        hex = hex.substring(3);
        int remBytes = 28;
        int index = 2;
        for (int i = 0; i < remBytes; i += 4) {
            U[index++] = this.adc2volt(Integer.parseInt(hex.substring(i + 1, i + 4), 16));
        }
        return this.leadVoltages(U);
    }

    private byte[] toPrimitive(Byte[] bytes) {
        byte[] arr = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            arr[i] = bytes[i];
        }
        return arr;
    }

    private boolean connected(int connectionByte) {
        return connectionByte == 15;
    }

    private Double[] leadVoltages(double[] U) {
        double U1 = U[1];
        double U2 = U[2];
        double U3 = U[3];
        double U4 = U[4];
        double U5 = U[5];
        double U6 = U[6];
        double U7 = U[7];
        double U8 = U[8];
        this.checkForBreak(U);
        double S = (U8 + U6) / 3.0;
        double I = U8 - U6;
        double II = -U6;
        double III = -U8;
        double aVR = U6 - U8 / 2.0;
        double aVL = U8 - U6 / 2.0;
        double aVF = -(U8 + U6) / 2.0;
        double V1 = this.leadBreak[2] > 100 && this.connectionByte != 15 && this.connectionByte != 4 && this.connectionByte != 6 && this.connectionByte > 2 ? 0.0 : U2 - S;
        double V2 = this.leadBreak[5] > 100 && this.connectionByte != 15 && this.connectionByte > 2 && this.connectionByte != 6 ? 0.0 : U5 - S;
        double V3 = this.leadBreak[7] > 100 && this.connectionByte != 15 && this.connectionByte != 1 && this.connectionByte != 2 && this.connectionByte != 6 ? 0.0 : U7 - S;
        double V4 = this.leadBreak[4] > 100 && this.connectionByte != 15 && this.connectionByte != 2 && this.connectionByte != 6 ? 0.0 : U4 - S;
        double V5 = this.leadBreak[3] > 100 && this.connectionByte != 15 && this.connectionByte != 6 ? 0.0 : U3 - S;
        double V6 = this.leadBreak[1] > 100 && this.connectionByte != 15 ? 0.0 : U1 - S;
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }

    private void checkForBreak(double[] U) {
        for (int i = 1; i < U.length; ++i) {
            if (this.p_U[i] == U[i]) {
                int n = i;
                this.leadBreak[n] = this.leadBreak[n] + 1;
            } else {
                this.leadBreak[i] = 0;
            }
            if (this.leadBreak[i] <= 101) continue;
            this.leadBreak[i] = 101;
        }
        System.arraycopy(U, 0, this.p_U, 0, U.length);
    }
}

