/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.ek12t;

import cmc.ecg.driver.source.ek12t.EK12TAbstractDataConverter;
import cmc.ecg.driver.utils.Utils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EK12TRecordedDataConverter
extends EK12TAbstractDataConverter {
    private static final Logger log = LoggerFactory.getLogger(EK12TRecordedDataConverter.class);
    private static final Byte PACKET_END = 10;

    public EK12TRecordedDataConverter(List<Byte> data) {
        super(data);
    }

    protected Byte getPacketEnd() {
        return PACKET_END;
    }

    public boolean canParse() {
        return Collections.lastIndexOfSubList(this.buffer, Arrays.asList((byte)13, (byte)10)) > -1;
    }

    public Double[] next() {
        List packet = this.getNextRawPacket();
        String text = Utils.byteListToString((List)packet, (Charset)StandardCharsets.UTF_8);
        log.trace("Converting packet: {}", (Object)text);
        String[] textArray = text.trim().split(" ");
        Double[] signal = new Double[12];
        try {
            int index = 0;
            for (String s : textArray) {
                String t = s.trim();
                if (t.equals("")) continue;
                signal[index++] = this.adc2volt(Integer.parseInt(t));
            }
        }
        catch (NumberFormatException e) {
            return new Double[0];
        }
        return signal;
    }
}

