/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.fastecg;

import cmc.ecg.driver.device.ComPortDataConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FastecgDataConverter
extends ComPortDataConverter {
    private static final List<Byte> HEADER = Arrays.asList((byte)-1, (byte)-1, (byte)-1, (byte)-1);
    private static final int BASELINE = 0x800000;
    private final boolean amplifierEnabled;

    public FastecgDataConverter(List<Byte> data, boolean amplifierEnabled) {
        super(data);
        this.amplifierEnabled = amplifierEnabled;
    }

    public boolean hasNext() {
        int headerIndex = Collections.indexOfSubList(this.buffer, HEADER);
        return headerIndex > -1 && this.buffer.size() >= headerIndex + 28;
    }

    public Double[] next() {
        int headerIndex = Collections.indexOfSubList(this.buffer, HEADER);
        if (headerIndex == -1) {
            return new Double[0];
        }
        ArrayList packet = new ArrayList(this.buffer.subList(headerIndex, headerIndex + 28));
        this.clear(headerIndex + 28);
        double millivoltRate = 3495.252916666667;
        double divisor = this.amplifierEnabled ? millivoltRate * 6.0 : millivoltRate;
        double I = (double)this.getValueFromIndex(packet, 4) / divisor;
        double II = (double)this.getValueFromIndex(packet, 7) / divisor;
        double III = II - I;
        double aVR = -(I + II) / 2.0;
        double aVL = I - II / 2.0;
        double aVF = II - I / 2.0;
        double V1 = (double)this.getValueFromIndex(packet, 10) / divisor - (II - III);
        double V2 = (double)this.getValueFromIndex(packet, 13) / divisor - (II - III);
        double V3 = (double)this.getValueFromIndex(packet, 16) / divisor - (II - III);
        double V4 = (double)this.getValueFromIndex(packet, 19) / divisor - (II - III);
        double V5 = (double)this.getValueFromIndex(packet, 22) / divisor - (II - III);
        double V6 = (double)this.getValueFromIndex(packet, 25) / divisor - (II - III);
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }

    private int getValueFromIndex(List<Byte> packet, int from) {
        return ((packet.get(from) & 0xFF) << 16 | (packet.get(from + 1) & 0xFF) << 8 | packet.get(from + 2) & 0xFF) - 0x800000;
    }
}

