/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.json;

import cmc.ecg.driver.device.AbstractDataProcessor;
import cmc.ecg.driver.device.FileConnection;
import cmc.ecg.driver.source.json.JsonDataProcessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.json.JacksonJsonParser;

public class JsonFileConnection
extends FileConnection<Double[]> {
    private static final Logger log = LoggerFactory.getLogger(JsonFileConnection.class);
    private static final String NAMES = "names";
    private static final String FS = "fs";
    private final Integer fs;
    private final List<String> names;
    private final List<List<Object>> leads;

    public JsonFileConnection(String json) {
        super((AbstractDataProcessor)new JsonDataProcessor());
        JacksonJsonParser parser = new JacksonJsonParser();
        Map map = parser.parseMap(json);
        this.fs = (Integer)map.get(FS);
        this.names = (List)map.get(NAMES);
        this.leads = this.names.stream().map(name -> (List)map.get(name)).collect(Collectors.toList());
    }

    public void processOnce() {
        try {
            long lastTime = System.currentTimeMillis();
            int counter = 0;
            int framesPerTenSeconds = this.fs / 100;
            int size = ((List)this.leads.get(0)).size();
            for (int point = 0; point < size && this.connected; ++point) {
                Double[] signal = new Double[this.names.size()];
                for (int lead = 0; lead < this.names.size(); ++lead) {
                    signal[lead] = Double.valueOf(((List)this.leads.get(lead)).get(point).toString());
                }
                this.processor.process((Object)signal);
                if (++counter % framesPerTenSeconds != 0) continue;
                long currentTime = System.currentTimeMillis();
                long sleepInterval = 10L - currentTime + lastTime;
                if (sleepInterval > 0L) {
                    Thread.sleep(sleepInterval);
                }
                lastTime = currentTime + sleepInterval;
            }
        }
        catch (Exception e) {
            log.error("Error while processing JSON file", (Throwable)e);
        }
    }

    public int getFs() {
        return this.fs == null ? 0 : this.fs;
    }
}

