/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.miniecg;

import cmc.ecg.driver.device.ComPortDataConverter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniecgDataConverter
extends ComPortDataConverter {
    private static final Logger log = LoggerFactory.getLogger(MiniecgDataConverter.class);
    private final int[] checksumTable = new int[256];
    private List<Byte> packet;
    private int packetEnd = 0;

    public MiniecgDataConverter(List<Byte> data) {
        super(data);
        for (int i = 0; i < 256; ++i) {
            int c = i << 24;
            for (int j = 0; j < 8; ++j) {
                boolean msb = (c & Integer.MIN_VALUE) != 0;
                c <<= 1;
                if (!msb) continue;
                c ^= 0x4C11DB7;
            }
            this.checksumTable[i] = c;
        }
    }

    public boolean hasNext() {
        int index = 0;
        while (true) {
            if (index > this.buffer.size() - 35) {
                return false;
            }
            this.packet = new ArrayList(this.buffer.subList(index, index + 35));
            if (this.validateChecksum(this.packet)) break;
            if (this.packetEnd != 0) {
                log.trace("Invalid checksum");
            }
            ++index;
        }
        this.packetEnd = index + 31;
        return true;
    }

    private boolean validateChecksum(List<Byte> packet) {
        int crc = -1;
        for (int i = 0; i < 31; ++i) {
            crc = this.checksum(crc, packet.get(i).byteValue());
        }
        crc = this.checksum(crc, (byte)0);
        byte crc3 = (byte)(crc >> 24 & 0x7F);
        byte crc2 = (byte)(crc >> 16 & 0x7F);
        byte crc1 = (byte)(crc >> 8 & 0x7F);
        byte crc0 = (byte)(crc & 0x7F);
        return crc3 == packet.get(31) && crc2 == packet.get(32) && crc1 == packet.get(33) && crc0 == packet.get(34);
    }

    private int checksum(int crc, byte b) {
        return crc << 8 ^ this.checksumTable[(crc >> 24 ^ b) & 0xFF];
    }

    public Double[] next() {
        this.clear(this.packetEnd);
        byte packetType = (Byte)this.packet.get(4);
        if (packetType == 0) {
            byte b;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 5; i < 31 && (b = ((Byte)this.packet.get(i)).byteValue()) != 0; ++i) {
                if (32 <= b && b <= 126) {
                    stringBuilder.append(b);
                    continue;
                }
                stringBuilder.append("\\x").append(String.format("%02X", b));
            }
            log.debug(stringBuilder.toString());
            return new Double[0];
        }
        double scale = this.getScale(((Byte)this.packet.get(4)).byteValue());
        double I = (double)this.getValueFromIndex(this.packet, 7) / scale;
        double II = (double)this.getValueFromIndex(this.packet, 10) / scale;
        double III = II - I;
        double aVR = -(I + II) / 2.0;
        double aVL = I - II / 2.0;
        double aVF = II - I / 2.0;
        double V1 = (double)this.getValueFromIndex(this.packet, 13) / scale;
        double V2 = (double)this.getValueFromIndex(this.packet, 16) / scale;
        double V3 = (double)this.getValueFromIndex(this.packet, 19) / scale;
        double V4 = (double)this.getValueFromIndex(this.packet, 22) / scale;
        double V5 = (double)this.getValueFromIndex(this.packet, 25) / scale;
        double V6 = (double)this.getValueFromIndex(this.packet, 28) / scale;
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }

    private double getScale(byte packetType) {
        switch (packetType) {
            case 1: {
                return 163.83499999999998;
            }
            case 2: {
                return 41943.035;
            }
        }
        return 1.0;
    }

    private int getValueFromIndex(List<Byte> packet, int from) {
        int b2;
        int b1;
        int b0 = packet.get(from) & 0xFF;
        int value = b0 << 16 | (b1 = packet.get(from + 1) & 0xFF) << 8 | (b2 = packet.get(from + 2) & 0xFF);
        if (value >= 0x800000) {
            value -= 0x1000000;
        }
        return value;
    }
}

