/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.pe1201a;

import cmc.ecg.driver.device.ComPortDataConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PE1201ADataConverter
extends ComPortDataConverter {
    private static final Logger log = LoggerFactory.getLogger(PE1201ADataConverter.class);
    private static final int PKG_A3_SIZE = 35;
    private static final int PKG_A4_SIZE = 43;
    private static final byte HEADER1 = -86;
    private static final byte HEADER2 = 85;
    private static final byte PKG_A3_FLAG = -93;
    private static final byte PKG_A4_FLAG = -92;
    private static final List<Byte> PKG_A3_HEADER_LIST = Arrays.asList((byte)-86, (byte)85, (byte)-93);
    private static final List<Byte> PKG_A4_HEADER_LIST = Arrays.asList((byte)-86, (byte)85, (byte)-92);
    private static final int BASELINE = 524288;
    private static final double RESOLUTION = 0.002288818359375;
    private final Integer[] fiducial = new Integer[8];
    private int packetStart;
    private List<Byte> packet;
    private Double[] sample1;
    private Double[] sample2;
    private boolean sample1sent = false;

    public PE1201ADataConverter(List<Byte> data) {
        super(data);
    }

    public boolean hasNext() {
        if (this.sample1sent) {
            return true;
        }
        int pkgA3StartIndex = Collections.indexOfSubList(this.buffer, PKG_A3_HEADER_LIST);
        int pkgA4StartIndex = Collections.indexOfSubList(this.buffer, PKG_A4_HEADER_LIST);
        if (pkgA3StartIndex == -1 && pkgA4StartIndex == -1) {
            return false;
        }
        if (pkgA3StartIndex > -1 && (pkgA4StartIndex == -1 || pkgA3StartIndex < pkgA4StartIndex) && this.buffer.size() >= pkgA3StartIndex + 35) {
            this.packetStart = pkgA3StartIndex;
            this.packet = new ArrayList(this.buffer.subList(pkgA3StartIndex, pkgA3StartIndex + 35));
            return true;
        }
        if (pkgA4StartIndex > -1 && (pkgA3StartIndex == -1 || pkgA4StartIndex < pkgA3StartIndex) && this.buffer.size() >= pkgA4StartIndex + 43) {
            this.packetStart = pkgA4StartIndex;
            this.packet = new ArrayList(this.buffer.subList(pkgA4StartIndex, pkgA4StartIndex + 43));
            return true;
        }
        return false;
    }

    public Double[] next() {
        Double[] result = new Double[]{};
        if (this.sample1sent) {
            this.sample1sent = false;
            result = this.sample2;
        } else {
            if (this.packet == null) {
                log.trace("Invalid packet: null");
            }
            if (this.packet.size() == 35) {
                this.clear(this.packetStart + 35);
                if (this.convertA3(this.packet)) {
                    this.sample1sent = true;
                    result = this.sample1;
                }
            }
            if (this.packet.size() == 43) {
                this.clear(this.packetStart + 43);
                if (this.convertA4(this.packet)) {
                    this.sample1sent = true;
                    result = this.sample1;
                }
            }
        }
        return result;
    }

    private boolean convertA3(List<Byte> packet) {
        if (Arrays.stream(this.fiducial).anyMatch(Objects::isNull)) {
            log.trace("No fiducial data");
            return false;
        }
        double[] smpl1 = new double[8];
        double[] smpl2 = new double[8];
        for (int i = 0; i < 8; ++i) {
            smpl1[i] = (double)(this.fiducial[i] + this.convert2btoi(packet.get(2 * i + 3).byteValue(), packet.get(2 * i + 4).byteValue()) - 524288) * 0.002288818359375;
            smpl2[i] = (double)(this.fiducial[i] + this.convert2btoi(packet.get(2 * i + 19).byteValue(), packet.get(2 * i + 20).byteValue()) - 524288) * 0.002288818359375;
        }
        this.sample1 = this.convert8chto12lead(smpl1[0], smpl1[1], smpl1[2], smpl1[3], smpl1[4], smpl1[5], smpl1[6], smpl1[7]);
        this.sample2 = this.convert8chto12lead(smpl2[0], smpl2[1], smpl2[2], smpl2[3], smpl2[4], smpl2[5], smpl2[6], smpl2[7]);
        return true;
    }

    private boolean convertA4(List<Byte> packet) {
        double[] smpl1 = new double[8];
        double[] smpl2 = new double[8];
        for (int i = 0; i < 8; ++i) {
            this.fiducial[i] = this.convert3btoi(packet.get(3 * i + 3).byteValue(), packet.get(3 * i + 4).byteValue(), packet.get(3 * i + 5).byteValue());
            smpl1[i] = (double)(this.fiducial[i] - 524288) * 0.002288818359375;
            smpl2[i] = (double)(this.fiducial[i] + this.convert2btoi(packet.get(2 * i + 27).byteValue(), packet.get(2 * i + 28).byteValue()) - 524288) * 0.002288818359375;
        }
        this.sample1 = this.convert8chto12lead(smpl1[0], smpl1[1], smpl1[2], smpl1[3], smpl1[4], smpl1[5], smpl1[6], smpl1[7]);
        this.sample2 = this.convert8chto12lead(smpl2[0], smpl2[1], smpl2[2], smpl2[3], smpl2[4], smpl2[5], smpl2[6], smpl2[7]);
        log.trace("Fiducial: {}", (Object)Arrays.toString((Object[])this.fiducial));
        return true;
    }

    private int convert3btoi(byte b1, byte b2, byte b3) {
        return (b3 & 0xF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    private short convert2btoi(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    private Double[] convert8chto12lead(double ch1, double ch2, double ch3, double ch4, double ch5, double ch6, double ch7, double ch8) {
        double I = -ch1 + ch2;
        double II = -ch1;
        double III = -ch2;
        double aVR = ch1 - ch2 / 2.0;
        double aVL = -ch1 / 2.0 + ch2;
        double aVF = -(ch1 + ch2) / 2.0;
        double V1 = ch3;
        double V2 = ch4;
        double V3 = ch5;
        double V4 = ch6;
        double V5 = ch7;
        double V6 = ch8;
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }
}

