/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.sapa;

import cmc.ecg.driver.device.AbstractDataProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapaDataProcessor
extends AbstractDataProcessor<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(SapaDataProcessor.class);
    private static final double SCALE = 12582.9105;

    public void process(byte[] data) {
        boolean b4;
        boolean b0 = (data[0] & 0xF0) == 192;
        boolean b1 = (data[2] & 0xF) == 0;
        boolean b3 = (data[27] & 0xF0) == 192;
        boolean bl = b4 = (data[29] & 0xF) == 0;
        if (!(b0 && b1 && b3 && b4)) {
            return;
        }
        int v6 = this.getRawValue(data, 3);
        int i = this.getRawValue(data, 6);
        int ii = this.getRawValue(data, 9);
        int v2 = this.getRawValue(data, 12);
        int v3 = this.getRawValue(data, 15);
        int v4 = this.getRawValue(data, 18);
        int v5 = this.getRawValue(data, 21);
        int v1 = this.getRawValue(data, 24);
        this.submit(this.getFullSignal(i, ii, v1, v2, v3, v4, v5, v6));
        v6 = this.getRawValue(data, 30);
        i = this.getRawValue(data, 33);
        ii = this.getRawValue(data, 36);
        v2 = this.getRawValue(data, 39);
        v3 = this.getRawValue(data, 42);
        v4 = this.getRawValue(data, 45);
        v5 = this.getRawValue(data, 48);
        v1 = this.getRawValue(data, 51);
        this.submit(this.getFullSignal(i, ii, v1, v2, v3, v4, v5, v6));
    }

    private int getRawValue(byte[] bytes, int offset) {
        int result = (bytes[offset] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset + 2] & 0xFF;
        return result < 0x800000 ? result : result - 0x1000000;
    }

    private Double[] getFullSignal(int i, int ii, int v1, int v2, int v3, int v4, int v5, int v6) {
        double I = (double)i / 12582.9105;
        double II = (double)ii / 12582.9105;
        double III = II - I;
        double aVR = -(I + II) / 2.0;
        double aVL = I - II / 2.0;
        double aVF = II - I / 2.0;
        double V1 = (double)v1 / 12582.9105;
        double V2 = (double)v2 / 12582.9105;
        double V3 = (double)v3 / 12582.9105;
        double V4 = (double)v4 / 12582.9105;
        double V5 = (double)v5 / 12582.9105;
        double V6 = (double)v6 / 12582.9105;
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }
}

