/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.source.ucard;

import cmc.ecg.driver.device.ComPortDataConverter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcardDataConverter
extends ComPortDataConverter {
    private static final Logger log = LoggerFactory.getLogger(UcardDataConverter.class);
    private static final int PACKET_SIZE = 22;

    public UcardDataConverter(List<Byte> data) {
        super(data);
    }

    public boolean hasNext() {
        if (this.buffer.size() < 22) {
            return false;
        }
        for (int i = 0; i < this.buffer.size() - 2; ++i) {
            if ((Byte)this.buffer.get(i) != 126 || (Byte)this.buffer.get(i + 1) != -127 && (Byte)this.buffer.get(i + 1) != -126 || (Byte)this.buffer.get(i + 2) != 54 && (Byte)this.buffer.get(i + 2) != 55 && (Byte)this.buffer.get(i + 2) != 56 && (Byte)this.buffer.get(i + 2) != 57) continue;
            if (this.buffer.size() - i < 22) {
                return false;
            }
            this.clear(i);
            return true;
        }
        return false;
    }

    public Double[] next() {
        ArrayList packet = new ArrayList(this.buffer.subList(0, 22));
        this.clear(22);
        int checksum = 0;
        for (int i = 3; i < 21; ++i) {
            checksum += (Byte)packet.get(i) & 0xFF;
        }
        byte byteChecksum = (byte)(checksum & 0xFF);
        if ((Byte)packet.get(21) != byteChecksum) {
            log.warn("Invalid checksum");
            return new Double[0];
        }
        double scale = 484.0;
        double I = (double)((Byte)packet.get(3) << 4 | (Byte)packet.get(6) >> 4 & 0xF) / scale;
        double II = (double)((Byte)packet.get(4) << 4 | (Byte)packet.get(6) & 0xF) / scale;
        double III = (double)((Byte)packet.get(5) << 4 | (Byte)packet.get(7) >> 4 & 0xF) / scale;
        double aVR = -(I + II) / 2.0;
        double aVL = (I - III) / 2.0;
        double aVF = (II + III) / 2.0;
        double V1 = (double)((Byte)packet.get(9) << 4 | (Byte)packet.get(8) >> 4 & 0xF) / scale;
        double V2 = (double)((Byte)packet.get(10) << 4 | (Byte)packet.get(8) & 0xF) / scale;
        double V3 = (double)((Byte)packet.get(11) << 4 | (Byte)packet.get(15) >> 4 & 0xF) / scale;
        double V4 = (double)((Byte)packet.get(12) << 4 | (Byte)packet.get(15) & 0xF) / scale;
        double V5 = (double)((Byte)packet.get(13) << 4 | (Byte)packet.get(16) >> 4 & 0xF) / scale;
        double V6 = (double)((Byte)packet.get(14) << 4 | (Byte)packet.get(16) & 0xF) / scale;
        return new Double[]{I, II, III, aVR, aVL, aVF, V1, V2, V3, V4, V5, V6};
    }
}

