/*
 * Decompiled with CFR 0.152.
 */
package cmc.ecg.driver.utils;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static void concat(List<Byte> list, byte[] arr) {
        for (byte b : arr) {
            list.add(b);
        }
    }

    public static List<Byte> slice(List<Byte> list, int from, int to) {
        if (from > list.size()) {
            from = 0;
        }
        if (to <= 0 || to > list.size()) {
            to = list.size();
        }
        return list.subList(from, to);
    }

    public static String byteListToString(List<Byte> byteList, Charset charset) {
        if (byteList == null) {
            return "";
        }
        byte[] array = new byte[byteList.size()];
        int i = 0;
        for (Byte b : byteList) {
            array[i] = b;
            ++i;
        }
        return new String(array, charset);
    }

    public static int indexOfTwoNegativeBytes(List<Byte> bytes) {
        if (bytes == null || bytes.size() < 2) {
            return -1;
        }
        for (int i = 0; i < bytes.size() - 1; ++i) {
            byte b1 = bytes.get(i);
            byte b2 = bytes.get(i + 1);
            if (b1 >= 0 || b2 >= 0) continue;
            return i;
        }
        return -1;
    }

    public static double round3(double v) {
        return (double)Math.round(v * 1000.0) / 1000.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean pingHost(String host, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), timeout);
            log.trace("Host {} was pinged successfully", (Object)host);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.trace("Host {} could not be pinged", (Object)host);
            return false;
        }
    }

    public static void checkOldLogs(String folderStr) {
        File folder = new File(folderStr);
        for (File fileEntry : Objects.requireNonNull(folder.listFiles())) {
            if (fileEntry.isDirectory()) continue;
            Utils.removeOldLogs((File)fileEntry);
        }
    }

    public static void removeOldLogs(File logFile) {
        try {
            BasicFileAttributes attr = Files.readAttributes(logFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            Clock clock = Clock.systemUTC();
            Instant fileInstant = attr.creationTime().toInstant();
            Instant now = clock.instant();
            Duration difference = Duration.between(fileInstant, now);
            long days = difference.toDays();
            if (days > 14L) {
                logFile.delete();
            }
        }
        catch (IOException e) {
            log.trace("Can not delete file");
        }
    }
}

