import './sockjs.min.js'
import './stomp.min.js'

export default new class Driver {
  constructor() {
    this.base = `${window.location}`
    this.client = null
    this.requestConfig = {
      headers: {
        'Content-Type': 'application/json; charset=UTF-8',
        'Accept': 'application/json; charset=UTF-8'
      }
    };
  }

  openSettingsPage() {
    const settings = window.open(this.base, '_blank')
    settings.focus()
  }

  async connect(connection) {
    if (!connection) {
      return (await axios.get(`${this.base}/connection`, this.requestConfig)).data
    } else {
      return (await axios.put(`${this.base}/connection`, connection, this.requestConfig)).data
    }
  }

  async ports() {
    return (await axios.get(`${this.base}/ports`, this.requestConfig)).data
  }

  async signals() {
    return (await axios.get(`${this.base}/signals`, this.requestConfig)).data[0].files
  }

  async devices() {
    return (await axios.get(`${this.base}/sources`, this.requestConfig)).data
  }

  listen(callback) {
    if (!callback) {
      throw 'No callback set';
    }

    console.info('Connecting to driver');
    const socket = new SockJS(`${this.base}/smartecg`);
    this.client = Stomp.over(socket);
    this.client.debug = false;
    this.client.connect({}, () => {
      console.log('Connected to driver');
      this.client.subscribe('/signal', frame => {
        callback(JSON.parse(frame.body))
      });
    });
  }

  disconnect() {
    console.info('Disconnecting from driver');
    if (!this.client) {
      console.warn('No connection exists');
      return;
    }

    this.client.disconnect();
    console.info('Disconnected from driver');
  }
}